/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bs.content;

import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_bs.content.TierMaterials;

public class TieredBlockList<T extends Block>
implements Iterable<BlockEntry<T>> {
    private static final int AMOUNT = TierMaterials.values().length;
    private final BlockEntry<?>[] values = new BlockEntry[AMOUNT];

    public TieredBlockList(Function<TierMaterials, BlockEntry<? extends T>> filler) {
        for (TierMaterials tier : TierMaterials.values()) {
            this.values[tier.ordinal()] = filler.apply(tier);
        }
    }

    public BlockEntry<T> get(TierMaterials tier) {
        return this.values[tier.ordinal()];
    }

    @Override
    @NotNull
    public Iterator<BlockEntry<T>> iterator() {
        return new Iterator<BlockEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TieredBlockList.this.values.length;
            }

            @Override
            public BlockEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return TieredBlockList.this.values[this.index++];
            }
        };
    }
}

